unit ClipUnit;

{ 45 Clipper functions you can use in Delphi
  AUTHOR:  Chris Butterworth, Midnight Oil Software, 100537,2512 }

interface

{         Abs() is the same in PASCAL }
function  AllTrim(str: string) : string;
function  ASC(str : string) : byte;
function  At(Subst: string; str: string) : integer;
function  CDOW(Date: TDateTime) : string;
{         Chr() is the same in PASCAL }
procedure CLS;
function  CMonth(Date: TDateTime) : string;
function  Col : byte;
function  CToD(cDate: string) : TDateTime;
{         Date()  use PASCAL function Date with DecodeDate() etc }
function  DayNo(Date : TDateTime) : byte;   { closest I can get to Day() }
function  DiskSpace(Drive: Byte): Longint;
procedure DispBox(t,l,b,r : byte);
procedure DevOut(str : string);       { strings only }
procedure DevPos(row, col: Byte);
function  DOW(Date: TDateTime): Integer;
function  DToC(Date : TDateTime) : string;
function  DToS(Date : TDateTime) : string;
function  EmptyDate(Date : TDateTime) : boolean;
function  EmptyStrg(str : string) : boolean;
{         Exp() is the same in PASCAL }
function  Ferase(str: string) : boolean;
{         File() cannot be defined; FILE is a reserved word; use FileExists() }
function  IIFDate(c1 : boolean; ret1,ret2 : TDateTime) : TDateTime;
function  IIFInt(c1 : boolean; ret1,ret2 : integer) : integer;
function  IIFReal(c1 : boolean; ret1,ret2 : extended) : extended;
function  IIFStr(c1 : boolean; ret1,ret2 : string) : string;
{         Int() is the same in PASCAL }
function  IsAlpha(str: string) : boolean;
function  IsDigit(str: string) : boolean;
function  IsLower(str: string) : boolean;
function  IsUpper(str: string) : boolean;
function  Left(str: string; num: integer) : string;
function  Len(str: string) : integer;
{         Log() use Ln() instead and you won't get confused with Log base 10 }
function  Lower(str: string) : string;
function  LTrim(str: string) : string;
function  MaxDate(d1,d2 : TDateTime) : TDateTime;
function  MaxInt(i1,i2 : integer) : integer;
function  MaxReal(r1,r2 : extended) : extended;
function  MaxStr(str1,str2 : string) : string;
function  MinDate(d1,d2 : TDateTime) : TDateTime;
function  MinInt(i1,i2 : integer) : integer;
function  MinReal(r1,r2 : extended) : extended;
function  MinStr(str1,str2 : string) : string;
function  MonthNo(Date : TDateTime) : word;  { closest I can get to Month() }
function  PadC(str: string; lngth : integer) : string;
function  PadL(str: string; lngth : integer) : string;
function  PadR(str: string; lngth : integer) : string;
{         Qout()  or ?   use WriteLn()   }
{         QQout() or ??  use Write()     }
function  Replicate(str: char; lngth : integer) : string;
function  Right(str: string; num: integer) : string;
{         Round()  is the same in PASCAL   }
function  Row : byte;
function  RTrim(str: string) : string;
function  Space(lngth : integer) : string;
{         SqRt()   is the same in PASCAL   }
{         Str() cannot be redefined; use Strg() or get used to
                                     using PASCAL procedure Str() }
function  Strg(X : real; w : word ; d : word) : string;  { like Clipper Str() }
function  StrTran(str: string; strfrom : string; strto : string) : string;
function  StrZero(X : Real; zwid : word ; decs : word) : string;
function  SubStr(str: string; pos: integer; num: integer) : string;
{         Time()  use PASCAL function Time  }
function  Trim(str: string) : string;
function  Upper(str: string) : string;
{         Val() cannot be redefined; get used to using PASCAL procedure Val() }
function  YearNo(Date : TDateTime) : word;  { closest I can get to Year() }


implementation

uses SysUtils, WinCRT;


{--------------------------------------}
function  AllTrim(str: string) : string;
{--------------------------------------}

begin
  Result := LTrim(RTrim(str))
end;


{---------------------------------}
function  ASC(str : string) : byte;
{---------------------------------}

var
  ch : char;

begin
  ch := str[1];
  Result := Ord(ch);
end;


{------------------------------------------------}
function  At(subst: string; str: string): integer; {to wrap PASCAL func "POS" }
{------------------------------------------------}

begin
  Result := Pos(subst,str)
end;


{--------------------------------------}
function CDOW(Date: TDateTime) : string;
{--------------------------------------}

var
  day : integer;

begin
  day := DayOfWeek(Date);
  case day of
     1 : Result := 'Sunday';
     2 : Result := 'Monday';
     3 : Result := 'Tuesday';
     4 : Result := 'Wednesday';
     5 : Result := 'Thursday';
     6 : Result := 'Friday';
     7 : Result := 'Saturday';
  end;
end;


{------------}
procedure CLS;
{------------}

begin
  ClrScr
end;


{----------------------------------------}
function CMonth(Date: TDateTime) : string;
{----------------------------------------}

var
  year,month,day : word;

begin
  DecodeDate(Date,year,month,day);
  case month of
     1 : Result := 'January';
     2 : Result := 'February';
     3 : Result := 'March';
     4 : Result := 'April';
     5 : Result := 'May';
     6 : Result := 'June';
     7 : Result := 'July';
     8 : Result := 'August';
     9 : Result := 'September';
    10 : Result := 'October';
    11 : Result := 'November';
    12 : Result := 'December';
  end;
end;


{-------------------}
function  Col : byte;
{-------------------}

begin
  Result := WhereX - 1
end;


{----------------------------------------}
function  CToD(cDate: string) : TDateTime;
{----------------------------------------}

var
  year,month,day : word;
  iCode : integer;  { throw away }

begin
  { make sure date is in the right format }
  { but not yet }
  Val(SubStr(cDate,1,2),day,iCode);
  Val(SubStr(cDate,4,2),month,iCode);
  Val(SubStr(cDate,7,2),year,iCode);
  Result := EncodeDate(year,month,day);
end;


{--------------------------------------}
function DayNo(Date : TDateTime) : byte;
{--------------------------------------}

var
  year,month,d : word;

begin
  DecodeDate(Date,year,month,d);
  Result := d
end;


{-----------------------------}
procedure DevOut(str : string);
{-----------------------------}

begin
  Write(str)
end;


{-------------------------------}
procedure DevPos(row, col: Byte);
{-------------------------------}

begin
  GotoXY(col+1,row+1)
end;


{----------------------------------------}
function  DiskSpace(Drive: Byte): Longint;
{----------------------------------------}

begin
  Result := DiskFree(Drive)
end;


{--------------------------------}
procedure DispBox(t,l,b,r : byte);
{--------------------------------}

var
  n : byte;

begin
  DevPos(t,l);
  DevOut(Replicate('-',r+1-l));
  DevPos(b,l);
  DevOut(Replicate('-',r+1-l));
  for n := t+1 to b-1 do
    begin
      DevPos(n,l);
      DevOut('|');
      DevPos(n,r);
      DevOut('|');
    end;
end;



{--------------------------------------}
function  DOW(Date: TDateTime): Integer;
{--------------------------------------}

begin
  Result := DayOfWeek(Date)
end;


{----------------------------------------}
function  DToC(Date : TDateTime) : string;  {to wrap PASCAL func "DateToStr()"}
{----------------------------------------}
begin
  Result := DateToStr(Date)
end;


{----------------------------------------}
function  DToS(Date : TDateTime) : string;
{----------------------------------------}

var
  year,month,day : word;

begin
  DecodeDate(Date,year,month,day);
  Result := StrZero(year,4,0) + StrZero(month,2,0) + StrZero(day,2,0)
end;


{----------------------------------------------}
function  EmptyDate(Date : TDateTime) : boolean;
{----------------------------------------------}

var
  year,month,day : word;

begin
  DecodeDate(Date,year,month,day);
  if (year=0) and (month=0) and (day=0) then
    Result := TRUE
  else
    Result := FALSE
end;


{------------------------------------------}
function  EmptyStrg(str : string) : boolean;
{------------------------------------------}

var
  n : word ;

begin
  Result := TRUE;
  if str <> EmptyStr then
    Result := FALSE
  else
    begin
      for n := 1 to Len(str) do
        if SubStr(str,n,1) <> ' ' then
          Result := FALSE
    end
end;


{--------------------------------------}
function  Ferase(str: string) : boolean;
{--------------------------------------}

begin
  Result := DeleteFile(str)
end;


{-----------------------------------------------------------------}
function  IIFDate(c1 : boolean; ret1,ret2 : TDateTime) : TDateTime;
{-----------------------------------------------------------------}

begin
  if c1 then
    Result := ret1
  else
    Result := ret2
end;


{------------------------------------------------------------}
function  IIFInt(c1 : boolean; ret1,ret2 : integer) : integer;
{------------------------------------------------------------}

begin
  if c1 then
    Result := ret1
  else
    Result := ret2
end;


{---------------------------------------------------------------}
function  IIFReal(c1 : boolean; ret1,ret2 : extended) : extended;
{---------------------------------------------------------------}

begin
  if c1 then
    Result := ret1
  else
    Result := ret2
end;


{----------------------------------------------------------}
function  IIFStr(c1 : boolean; ret1,ret2 : string) : string;
{----------------------------------------------------------}

begin
  if c1 then
    Result := ret1
  else
    Result := ret2
end;


{---------------------------------------}
function  IsAlpha(str: string) : boolean;
{---------------------------------------}

var
  asciinum : byte;
  ch : char;

begin
  Result := FALSE;
  {ch := 'a';
  ch := Char(Copy(str,1,1));  invalid type cast}
  ch := str[1];
  asciinum := Ord(ch);
  if ((asciinum >= 97) and (asciinum <= 122)) or
     ((asciinum >= 65) and (asciinum <= 90)) then
    Result := TRUE;
end;


{---------------------------------------}
function  IsDigit(str: string) : boolean;
{---------------------------------------}

var
  asciinum : byte;
  ch : char;

begin
  Result := FALSE;
  ch := str[1];
  asciinum := Ord(ch);
  if ((asciinum >= 48) and (asciinum <= 57)) then
    Result := TRUE;
end;


{---------------------------------------}
function  IsLower(str: string) : boolean;
{---------------------------------------}

var
  asciinum : byte;
  ch : char;

begin
  Result := FALSE;
  ch := str[1];
  asciinum := Ord(ch);
  if ((asciinum >= 97) and (asciinum <= 122)) then
    Result := TRUE;
end;


{---------------------------------------}
function  IsUpper(str: string) : boolean;
{---------------------------------------}

var
  asciinum : byte;
  ch : char;

begin
  Result := FALSE;
  ch := str[1];
  asciinum := Ord(ch);
  if ((asciinum >= 65) and (asciinum <= 90)) then
    Result := TRUE;
end;


{-------------------------------------------------}
function  Left(str: string; num: integer) : string;
{-------------------------------------------------}

begin
  Result := SubStr(str, 1, num)
end;


{-----------------------------------}
function  Len(str: string) : integer;   { to wrap PASCAL function "Length" }
{-----------------------------------}

begin
  Result := Length(str)
end;


{------------------------------------}
function  Lower(str: string) : string;  { to wrap PASCAL function "LOWERCASE" }
{------------------------------------}

begin
  Result := LowerCase(str)
end;


{------------------------------------}
function  LTrim(str: string) : string;
{------------------------------------}

begin
  while SubStr(str,1,1) = ' ' do
    str := SubStr(str,2,Len(str));
  Result := str
end;


{-----------------------------------------------}
function  MaxDate(d1,d2 : TDateTime) : TDateTime;
{-----------------------------------------------}

begin
  if d1 > d2 then
    Result := d1
  else
    Result := d2
end;


{------------------------------------------}
function  MaxInt(i1,i2 : integer) : integer;
{------------------------------------------}

begin
  if i1 > i2 then
    Result := i1
  else
    Result := i2
end;


{---------------------------------------------}
function  MaxReal(r1,r2 : extended) : extended;
{---------------------------------------------}

begin
  if r1 > r2 then
    Result := r1
  else
    Result := r2
end;


{--------------------------------------------}
function  MaxStr(str1,str2 : string) : string;
{--------------------------------------------}

begin
  if str1 > str2 then
    Result := str1
  else
    Result := str2
end;


{-----------------------------------------------}
function  MinDate(d1,d2 : TDateTime) : TDateTime;
{-----------------------------------------------}

begin
  if d1 < d2 then
    Result := d1
  else
    Result := d2
end;


{------------------------------------------}
function  MinInt(i1,i2 : integer) : integer;
{------------------------------------------}

begin
  if i1 < i2 then
    Result := i1
  else
    Result := i2
end;


{---------------------------------------------}
function  MinReal(r1,r2 : extended) : extended;
{---------------------------------------------}

begin
  if r1 < r2 then
    Result := r1
  else
    Result := r2
end;


{--------------------------------------------}
function  MinStr(str1,str2 : string) : string;
{--------------------------------------------}

begin
  if str1 < str2 then
    Result := str1
  else
    Result := str2
end;


{-----------------------------------------}
function  MonthNo(Date : TDateTime) : word;
{-----------------------------------------}

var
  year,month,day : word;

begin
  DecodeDate(Date,year,month,day);
  Result := month
end;


{----------------------------------------------------}
function  PadC(str: string; lngth : integer) : string;
{----------------------------------------------------}

begin
  str := SubStr(str,1,lngth);
  while Len(str) < lngth DO
    begin
      str := str + ' ';
      if Len(str) < lngth then
        str := ' ' + str;
    end;
  Result := str
end;


{----------------------------------------------------}
function  PADL(str: string; lngth : integer) : string;
{----------------------------------------------------}

begin
  str := SubStr(str,1,lngth);
  while (Len(str) < lngth) DO
    str := ' ' + str;
  Result := str
end;


{----------------------------------------------------}
function  PADR(str: string; lngth : integer) : string;
{----------------------------------------------------}

begin
  str := SubStr(str,1,lngth);
  while Len(str) < lngth DO
    str := str + ' ';
  Result := str
end;


{-------------------------------------------------------}
function  Replicate(str: char; lngth : integer) : string;
{-------------------------------------------------------}

var
  temp : string;

begin
  temp := '';
  while Len(temp) < lngth do
    temp := temp + str;
  Result := temp
end;


{--------------------------------------------------}
function  Right(str: string; num: integer) : string;
{--------------------------------------------------}

var i : byte;

begin
  if num >= Len(str) then
    Result := str
  else
    begin
      i := Len(str) - num + 1;
      Result := SubStr(str, i, num)
    end
end;


{------------------}
function Row : byte;
{------------------}

begin
  Result := WhereY - 1
end;


{------------------------------------}
function  RTrim(str: string) : string;
{------------------------------------}

begin
  while SubStr(str,Len(str),1) = ' ' do
    str := SubStr(str,1,Len(str)-1);
    Result := str
end;


{----------------------------------------}
function  Space(lngth : integer) : string;
{----------------------------------------}

begin
  Result := Replicate(' ',lngth)
end;


{----------------------------------------------------------}
function Strg(X : real; w : word ; d : word) : string;
{----------------------------------------------------------}

var
  XStr : string;

begin

  Str(X:w:d,XStr);     { <--- note the funny syntax see DU p 283}
  Result := XStr
end;


{------------------------------------------------------------------------}
function  StrTran(str: string; strfrom : string; strto : string) : string;
{------------------------------------------------------------------------}

var tempstr : string;
    outstr  : string;
    n       : integer;

begin
  outstr := '';
  for n := 1 to Len(str) do
    begin
      tempstr := SubStr(str,n,Len(strfrom));
      if tempstr = strfrom then
        begin
          outstr := outstr + strto;
          n := n + Len(strfrom) - 1
        end
      else
        outstr := outstr + SubStr(str,n,1);
    end;
  Result := outstr
end;


{-------------------------------------------------------------}
function StrZero(X : real; zwid : word ; decs : word) : string;
{-------------------------------------------------------------}

var absX : real;
    XStr,retStr : string;

begin
  absX := Abs(X);
  Str(absX:zwid:decs,XStr);     { <--- note the funny syntax see DU p 283}
  if (X < 0) and (SubStr(XStr,1,1) = ' ') then
    XStr := '-' + SubStr(XStr,2,Len(XStr)-1);
  Result := StrTran(XStr,' ','0')
end;


{---------------------------------------------------------------}
function  SubStr(str: string;pos: integer;num: integer) : string;
{---------------------------------------------------------------}
{ to wrap PASCAL function "COPY" }
begin
  Result := Copy(str,pos,num)
end;


{------------------------------------}
function  Trim(str: string) : string;
{------------------------------------}

begin
  while SubStr(str,Len(str),1) = ' ' do
    str := SubStr(str,1,Len(str)-1);
    Result := str
end;


{------------------------------------}
function  Upper(str: string) : string; { to wrap PASCAL function "UPPERCASE" }
{------------------------------------}

begin
  Result := UpperCase(str)
end;


{----------------------------------------}
function  YearNo(Date : TDateTime) : word;
{----------------------------------------}

var
  year,month,day : word;

begin
  DecodeDate(Date,year,month,day);
  Result := year
end;


end.
